IF EXISTS( SELECT * FROM sys.objects
			WHERE object_id = OBJECT_ID(N'[dbo].[P_PDV_CONSLD_VD_MOVIMENTO_GERACAO_FLAGS]')
				AND type IN(N'P', N'PC'))
    BEGIN
        DROP PROCEDURE [dbo].[P_PDV_CONSLD_VD_MOVIMENTO_GERACAO_FLAGS];
    END;
GO


--EXEC P_PDV_CONSLD_VD_MOVIMENTO_GERACAO_FLAGS 1,1,'2018-06-21','2018-06-21'
CREATE PROCEDURE [dbo].[P_PDV_CONSLD_VD_MOVIMENTO_GERACAO_FLAGS]( @CD_EMP    INT 
																		, @CD_FILIAL INT 
																		, @DT_INI    DATETIME 
																		, @DT_FIM    DATETIME)
WITH ENCRYPTION
AS


     SET NOCOUNT ON;
	
	------------------------------------------------------------------------------------------------------
	--Exportacao contabil
     UPDATE PDV_CONSLD_VD_MOVIMENTO
       SET
           PDV_CONSLD_VD_MOVIMENTO.FLAG_EXPORT_CTB = 1
     FROM CTB_CONTROLE_EXPORTACAO
          INNER JOIN PDV_CONSLD_VD_MOVIMENTO ON CTB_CONTROLE_EXPORTACAO.CD_EMP = PDV_CONSLD_VD_MOVIMENTO.CD_EMP
                                                AND CTB_CONTROLE_EXPORTACAO.CD_FILIAL = PDV_CONSLD_VD_MOVIMENTO.CD_FILIAL
                                                AND CTB_CONTROLE_EXPORTACAO.DT_EXPORT = PDV_CONSLD_VD_MOVIMENTO.DT_MOV
     WHERE
           PDV_CONSLD_VD_MOVIMENTO.CD_EMP = @CD_EMP
           AND PDV_CONSLD_VD_MOVIMENTO.CD_FILIAL = @CD_FILIAL
           AND PDV_CONSLD_VD_MOVIMENTO.DT_MOV BETWEEN @DT_INI AND @DT_FIM
           AND CTB_CONTROLE_EXPORTACAO.LIBERADO = 'N';
	
	------------------------------------------------------------------------------------------------------
	--Exportacao Fiscal
    UPDATE PDV_CONSLD_VD_MOVIMENTO
    SET
        PDV_CONSLD_VD_MOVIMENTO.FLAG_EXPOT_FISCAL = 1
    FROM CTB_EXP_CTR
        INNER JOIN PDV_CONSLD_VD_MOVIMENTO ON CTB_EXP_CTR.CD_EMP = PDV_CONSLD_VD_MOVIMENTO.CD_EMP
                                            AND CTB_EXP_CTR.CD_FILIAL = PDV_CONSLD_VD_MOVIMENTO.CD_FILIAL
                                            AND CTB_EXP_CTR.DT_EXP = PDV_CONSLD_VD_MOVIMENTO.DT_MOV
    WHERE
        PDV_CONSLD_VD_MOVIMENTO.CD_EMP = @CD_EMP
        AND PDV_CONSLD_VD_MOVIMENTO.CD_FILIAL = @CD_FILIAL
        AND PDV_CONSLD_VD_MOVIMENTO.DT_MOV BETWEEN @DT_INI AND @DT_FIM
        AND CTB_EXP_CTR.LIBERADO = 'N';

	------------------------------------------------------------------------------------------------------
	--Fechamento de caixa
	UPDATE PDV_CONSLD_VD_MOVIMENTO
	SET
		PDV_CONSLD_VD_MOVIMENTO.FLAG_CAIXA_FECHADO = 1
	FROM PDV_VD_FECHA_MOV
		INNER JOIN PDV_CONSLD_VD_MOVIMENTO ON PDV_VD_FECHA_MOV.CD_EMP = PDV_CONSLD_VD_MOVIMENTO.CD_EMP
											AND PDV_VD_FECHA_MOV.CD_FILIAL = PDV_CONSLD_VD_MOVIMENTO.CD_FILIAL
											AND PDV_VD_FECHA_MOV.DT_MOV = PDV_CONSLD_VD_MOVIMENTO.DT_MOV
	WHERE
		PDV_CONSLD_VD_MOVIMENTO.CD_EMP = @CD_EMP
		AND PDV_CONSLD_VD_MOVIMENTO.CD_FILIAL = @CD_FILIAL
		AND PDV_CONSLD_VD_MOVIMENTO.DT_MOV BETWEEN @DT_INI AND @DT_FIM;

	------------------------------------------------------------------------------------------------------
	--Bloqueio de caixa
    UPDATE PDV_CONSLD_VD_MOVIMENTO
    SET
        PDV_CONSLD_VD_MOVIMENTO.FLAG_CAIXA_BLOQUEADO = 1
    FROM PDV_VD_FECHA_MOV
        INNER JOIN PDV_CONSLD_VD_MOVIMENTO ON PDV_VD_FECHA_MOV.CD_EMP = PDV_CONSLD_VD_MOVIMENTO.CD_EMP
                                            AND PDV_VD_FECHA_MOV.CD_FILIAL = PDV_CONSLD_VD_MOVIMENTO.CD_FILIAL
                                            AND PDV_VD_FECHA_MOV.DT_MOV = PDV_CONSLD_VD_MOVIMENTO.DT_MOV
    WHERE
        PDV_CONSLD_VD_MOVIMENTO.CD_EMP = @CD_EMP
        AND PDV_CONSLD_VD_MOVIMENTO.CD_FILIAL = @CD_FILIAL
        AND PDV_CONSLD_VD_MOVIMENTO.DT_MOV BETWEEN @DT_INI AND @DT_FIM
        AND PDV_VD_FECHA_MOV.BLQ_ALT_FECHA = 1;

	------------------------------------------------------------------------------------------------------
	--Consolidacao de caixa
    UPDATE PDV_CONSLD_VD_MOVIMENTO
    SET
        PDV_CONSLD_VD_MOVIMENTO.FLAG_CAIXA_CONSOLIDADO = 1
    FROM PDV_VD_FECHA_MOV_TES
        INNER JOIN PDV_CONSLD_VD_MOVIMENTO ON PDV_VD_FECHA_MOV_TES.CD_EMP = PDV_CONSLD_VD_MOVIMENTO.CD_EMP
                                            AND PDV_VD_FECHA_MOV_TES.CD_FILIAL = PDV_CONSLD_VD_MOVIMENTO.CD_FILIAL
                                            AND PDV_VD_FECHA_MOV_TES.DT_MOV = PDV_CONSLD_VD_MOVIMENTO.DT_MOV
    WHERE
        PDV_CONSLD_VD_MOVIMENTO.CD_EMP = @CD_EMP
        AND PDV_CONSLD_VD_MOVIMENTO.CD_FILIAL = @CD_FILIAL
        AND PDV_CONSLD_VD_MOVIMENTO.DT_MOV BETWEEN @DT_INI AND @DT_FIM;

	------------------------------------------------------------------------------------------------------
	--Fechamento cartao
    UPDATE PDV_CONSLD_VD_MOVIMENTO
    SET
        PDV_CONSLD_VD_MOVIMENTO.FLAG_CARTAO_FECHADO = 1
    FROM RC_ADM_CARTAO_MOV_LOTE
        INNER JOIN PDV_CONSLD_VD_MOVIMENTO ON @CD_EMP = PDV_CONSLD_VD_MOVIMENTO.CD_EMP
                                            AND RC_ADM_CARTAO_MOV_LOTE.CD_FILIAL = PDV_CONSLD_VD_MOVIMENTO.CD_FILIAL
                                            AND RC_ADM_CARTAO_MOV_LOTE.DT_MOV = PDV_CONSLD_VD_MOVIMENTO.DT_MOV
    WHERE
        PDV_CONSLD_VD_MOVIMENTO.CD_EMP = @CD_EMP
        AND PDV_CONSLD_VD_MOVIMENTO.CD_FILIAL = @CD_FILIAL
        AND PDV_CONSLD_VD_MOVIMENTO.DT_MOV BETWEEN @DT_INI AND @DT_FIM;

	------------------------------------------------------------------------------------------------------
	--Ocorrencias no PDV
	UPDATE PDV_CONSLD_VD_MOVIMENTO
	SET
		PDV_CONSLD_VD_MOVIMENTO.FLAG_MOV_OCORRENCIA = 1
	FROM PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO
		INNER JOIN PDV_CONSLD_VD_MOVIMENTO ON PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO.CD_EMP = PDV_CONSLD_VD_MOVIMENTO.CD_EMP
											AND PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO.CD_FILIAL = PDV_CONSLD_VD_MOVIMENTO.CD_FILIAL
											AND PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO.DT_MOV = PDV_CONSLD_VD_MOVIMENTO.DT_MOV
	WHERE
		PDV_CONSLD_VD_MOVIMENTO.CD_EMP = @CD_EMP
		AND PDV_CONSLD_VD_MOVIMENTO.CD_FILIAL = @CD_FILIAL
		AND PDV_CONSLD_VD_MOVIMENTO.DT_MOV BETWEEN @DT_INI AND @DT_FIM;

	------------------------------------------------------------------------------------------------------
	UPDATE PDV_CONSLD_VD_MOVIMENTO
    SET
        PDV_CONSLD_VD_MOVIMENTO.CONSD_PENDENTE = 0
    FROM PDV_CONSLD_VD_MOVIMENTO
    WHERE
        PDV_CONSLD_VD_MOVIMENTO.CD_EMP = @CD_EMP
        AND PDV_CONSLD_VD_MOVIMENTO.CD_FILIAL = @CD_FILIAL
        AND PDV_CONSLD_VD_MOVIMENTO.DT_MOV BETWEEN @DT_INI AND @DT_FIM; 
		
	------------------------------------------------------------------------------------------------------
	--Ocorrencias de crediario pendente
    UPDATE PDV_CONSLD_VD_MOVIMENTO
    SET
        PDV_CONSLD_VD_MOVIMENTO.CONSD_PENDENTE = 1
    FROM PDV_CONSLD_VD_MOVIMENTO
        INNER JOIN V_RC_PGTO_PDV_PENDENTE ON PDV_CONSLD_VD_MOVIMENTO.CD_EMP = V_RC_PGTO_PDV_PENDENTE.CD_EMP
                                            AND PDV_CONSLD_VD_MOVIMENTO.CD_FILIAL = V_RC_PGTO_PDV_PENDENTE.CD_FILIAL
                                            AND PDV_CONSLD_VD_MOVIMENTO.DT_MOV = CONVERT(CHAR(10), V_RC_PGTO_PDV_PENDENTE.DT_PGTO, 101)
    WHERE
        PDV_CONSLD_VD_MOVIMENTO.CD_EMP = @CD_EMP
        AND PDV_CONSLD_VD_MOVIMENTO.CD_FILIAL = @CD_FILIAL
        AND PDV_CONSLD_VD_MOVIMENTO.DT_MOV BETWEEN @DT_INI AND @DT_FIM;